jQuery(document).ready(function($) {
    
    // 1. Obtener las plantillas de fila del DOM
    var generalTemplate = document.getElementById('bsk-row-template');
    var specialTemplate = document.getElementById('bsk-special-row-template');

    // --- FUNCIONES PARA PROGRAMACIÓN GENERAL (EFEMÉRIDES) ---
    function add_general_schedule_row() {
        if (generalTemplate && generalTemplate.content) {
            var new_row = generalTemplate.content.cloneNode(true);
            $('#bsk-schedule-rows').append(new_row); 
        } else {
             console.error("BSK Recordar Error: La plantilla 'bsk-row-template' no se encontró o no tiene contenido.");
        }
    }
    
    // Controlar la adición de fila general
    $('#bsk-add-row').on('click', function() {
        add_general_schedule_row();
    });
    
    // --- NUEVAS FUNCIONES PARA PROGRAMACIÓN ESPECIAL (ANUAL) ---
    function add_special_schedule_row() {
        if (specialTemplate && specialTemplate.content) {
            var new_row = specialTemplate.content.cloneNode(true);
            $('#bsk-special-schedule-rows').append(new_row); 
        } else {
             console.error("BSK Recordar Error: La plantilla 'bsk-special-row-template' no se encontró o no tiene contenido.");
        }
    }
    
    // Controlar la adición de fila especial
    $('#bsk-add-special-row').on('click', function() {
        add_special_schedule_row();
    });

    // 4. Controlar la eliminación de fila (Delegado, se aplica a ambas tablas)
    $('#bsk-schedule-table, #bsk-special-schedule-table').on('click', '.bsk-remove-row', function() {
        $(this).closest('tr').remove();
    });
    
    // 5. Serializar datos antes de enviar el formulario
    $('#bsk-recordar-form').on('submit', function(e) {
        
        // --- SERIALIZACIÓN GENERAL ---
        var general_schedule_data = [];
        // Iterar sobre todas las filas en el orden actual del DOM
        $('#bsk-schedule-rows .bsk-schedule-row').each(function() {
            var year = $(this).find('.bsk-year-selector').val();
            var time = $(this).find('.bsk-time-selector').val();
            
            if (year && time) {
                 general_schedule_data.push({
                    year: year,
                    time: time
                });
            }
        });
        $('#bsk-schedule-groups-array').val(JSON.stringify(general_schedule_data));
        if (general_schedule_data.length === 0) {
            $('#bsk-schedule-groups-array').val('[]');
        }

        // --- SERIALIZACIÓN ESPECIAL ---
        var special_schedule_data = [];
        $('#bsk-special-schedule-rows .bsk-special-schedule-row').each(function() {
            var month = $(this).find('.bsk-month-selector').val();
            var day = $(this).find('.bsk-day-selector').val();
            var time = $(this).find('.bsk-time-selector').val();
            var source = $(this).find('.bsk-source-selector').val();
            var value = $(this).find('.bsk-value-input').val();
            
            if (month && day && time && source && value) {
                 special_schedule_data.push({
                    month: month,
                    day: day,
                    time: time,
                    post_source: source,
                    post_value: value
                });
            }
        });
        // Colocar el array JSON en el campo oculto de programación especial
        $('#bsk-special-schedule-groups-array').val(JSON.stringify(special_schedule_data));
        if (special_schedule_data.length === 0) {
            $('#bsk-special-schedule-groups-array').val('[]');
        }
    });

    // 6. Inicializar Drag and Drop (Sortable)
    function init_sortable() {
        $("#bsk-schedule-rows").sortable({
            items: "tr.bsk-schedule-row",
            cursor: "grabbing",
            handle: "td" 
        });
        
        $("#bsk-special-schedule-rows").sortable({
            items: "tr.bsk-special-schedule-row",
            cursor: "grabbing",
            handle: "td" 
        });
    }
    
    init_sortable();
});